VERSION 5.00
Begin VB.Form FrmCmd 
   Caption         =   "Send Commands"
   ClientHeight    =   6255
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   8145
   LinkTopic       =   "Form1"
   ScaleHeight     =   6255
   ScaleWidth      =   8145
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton ClrDlgBtn 
      Caption         =   "Clear Dialog"
      Height          =   375
      Left            =   240
      TabIndex        =   4
      Top             =   1680
      Width           =   1455
   End
   Begin VB.TextBox ComDlgTxt 
      BackColor       =   &H8000000F&
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3615
      Left            =   240
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Top             =   2400
      Width           =   7695
   End
   Begin VB.TextBox MsgTxt 
      Height          =   285
      Left            =   240
      TabIndex        =   2
      Top             =   480
      Width           =   5655
   End
   Begin VB.CommandButton SendMsgBtn 
      Caption         =   "Send Message"
      Default         =   -1  'True
      Height          =   495
      Left            =   240
      TabIndex        =   3
      Top             =   840
      Width           =   5655
   End
   Begin VB.Label Label2 
      Caption         =   "Communication Dialog (Hex)"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   2160
      Width           =   2175
   End
   Begin VB.Label Label1 
      Caption         =   "Message (Hex)"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   1335
   End
End
Attribute VB_Name = "FrmCmd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private MsgByte As Byte
Private MsgIndex As Long




Private Sub ClrDlgBtn_Click()
    ComDlgTxt.Text = ""
End Sub

Private Sub Form_Load()
    InitUSB
End Sub

Private Sub Form_Unload(Cancel As Integer)
    CloseDevice
    CloseUSB
End Sub

Private Sub SendMsgBtn_Click()
'Sends,receives and displays device messages.

'Check for any fatal errors.
    If FatalError <> "" Then
        MsgBox ("Fatal Error - " & FatalError)
        Exit Sub
    End If
    
'See if the correct device has been detected
    If HidDevice = INVALID_HANDLE_VALUE Then
'See if the correct device is attached
        DetectDevice
        If HidDevice = INVALID_HANDLE_VALUE Then
            MsgBox ("Attach device before sending commands")
            Exit Sub
        End If
        If FatalError <> "" Then
            MsgBox ("Fatal Error - " & FatalError)
            Exit Sub
        End If
    End If
    
'Initialize command data
    InitCmd
    
' Interpret message set up the transmit data
    If Not InterpretMsg Then
        GoToMsgTxt
        Exit Sub
    End If
    
' Display Request
    DisplayComDlg ("Request")
    
' Send / Receive message
    SendCmd
    
' Display Response
    DisplayComDlg ("Response")
    
    GoToMsgTxt
    
End Sub

Private Sub DisplayComDlg(MsgType)
'Displays messages

    If ComDlgTxt.Text <> "" Then
        ComDlgTxt.Text = ComDlgTxt.Text & vbCrLf
    End If
    
    If MsgType = "Request" Then
        ComDlgTxt.Text = ComDlgTxt.Text & "Request      : CMND=" & ByteToHex(FtrRptTrxBfr(FRI_CMD)) _
        & ", DATA=" & ByteArrayToHexStr(FtrRptTrxBfr(), FtrRptTrxBfr(FRI_LEN))
    ElseIf MsgType = "Response" Then
        ComDlgTxt.Text = ComDlgTxt.Text & "Response     : "
        If SendCmdSts = SCS_SUCCESS Then
            ComDlgTxt.Text = ComDlgTxt.Text & "RC=" & ByteToHex(FtrRptRcvBfr(FRI_RC)) _
            & ", DATA=" & ByteArrayToHexStr(FtrRptRcvBfr(), FtrRptRcvBfr(FRI_LEN))
        ElseIf SendCmdSts = SCS_TRX_FAILED Then
            ComDlgTxt.Text = ComDlgTxt.Text & "Failure during transmit"
        ElseIf SendCmdSts = SCS_RCV_FAILED Then
            ComDlgTxt.Text = ComDlgTxt.Text & "Failure during receive"
        End If
    End If
    
    ComDlgTxt.SelStart = Len(ComDlgTxt.Text)
End Sub

Private Function InterpretMsg() As Boolean
'Checks the syntax of a message and converts the message into a format that can be
'sent to the device

    Dim NextByteResult As String
    Dim DataIndex As Long
    Dim FtrRptIndex As Long
    
    InterpretMsg = True
    MsgIndex = 1
    
    For FtrRptIndex = 1 To Capabilities.FeatureReportByteLength
        FtrRptTrxBfr(FtrRptIndex - 1) = 0
    Next
    
    If GetNextMsgByte() = "GotByte" Then
        FtrRptTrxBfr(FRI_CMD) = MsgByte
    Else
        HandleBadMsg
        InterpretMsg = False
        Exit Function
    End If
        
    DataIndex = FRI_DATA
    NextByteResult = "GotByte"
    Do While NextByteResult = "GotByte"
        NextByteResult = GetNextMsgByte()
        If NextByteResult = "GotByte" Then
            If DataIndex = Capabilities.FeatureReportByteLength Then
                MsgBox ("Data portion of message can't be longer than " & Capabilities.FeatureReportByteLength - 3 & " bytes")
                InterpretMsg = False
                Exit Function
            End If
            FtrRptTrxBfr(DataIndex) = MsgByte
            DataIndex = DataIndex + 1
        ElseIf NextByteResult = "BadMsg" Then
            HandleBadMsg
            InterpretMsg = False
            Exit Function
        End If
    Loop
    
    FtrRptTrxBfr(FRI_LEN) = DataIndex - FRI_DATA
End Function

Public Sub HandleBadMsg()
'Displays a message indicating a bad message syntax has been entered.

    MsgBox ("Bad Message.  Message should be hexidecimal in format ""CMND [DATA]""." & _
            vbCrLf & "For Example, ""00 00"".")
End Sub

Private Function GetNextMsgByte() As String
'Gets the next message byte from a string at MsgIndex position and stores it in
'MsgByte

    Dim GotChar As Boolean
    Dim TmpByte As Byte
    
    GetNextMsgByte = "MsgDone"
    MsgByte = 0
    GotChar = False
    
    Do While MsgIndex <= Len(MsgTxt.Text)
        AscVal = Asc(Mid(MsgTxt.Text, MsgIndex, 1))
        MsgIndex = MsgIndex + 1
        If AscVal = 9 Or AscVal = 10 Or AscVal = 13 Or AscVal = 32 Then
            If GotChar Then
                GetNextMsgByte = "GotByte"
                Exit Function
            End If
        ElseIf (AscVal >= 48 And AscVal <= 57) Or (AscVal >= 65 And AscVal <= 72) Or _
        (AscVal >= 97 And AscVal <= 102) Then
            If AscVal >= 65 And AscVal <= 72 Then
                TmpByte = AscVal - 55
            ElseIf AscVal >= 97 And AscVal <= 102 Then
                TmpByte = AscVal - 87
            Else
                TmpByte = AscVal - 48
            End If
            
            If GotChar Then
                MsgByte = MsgByte * 16 + TmpByte
                GetNextMsgByte = "GotByte"
                Exit Function
            Else
                GotChar = True
                MsgByte = TmpByte
            End If
        Else
            GetNextMsgByte = "BadMsg"
            Exit Function
        End If
    Loop
    
    If GotChar Then
        GetNextMsgByte = "GotByte"
    End If
End Function

Public Function ByteToHex(ByVal ByteVal As Byte) As String
'Converts a byte to a hexidecimal string for display purposes.

    ByteToHex = Hex(ByteVal)
    If Len(ByteToHex) = 1 Then
        ByteToHex = "0" & ByteToHex
    End If
End Function

Private Function ByteArrayToHexStr(ByRef ByteArray() As Byte, ByVal ArrayLen As Long) As String
'Translates a byte array to a hexidecimal string for display purposes.

    Dim i As Long
    Dim HexStr As String
    
    ByteArrayToHexStr = ""
    For i = 1 To ArrayLen
        HexStr = Hex(ByteArray(FRI_DATA + i - 1))
        
        If Len(HexStr) = 1 Then
            HexStr = "0" & HexStr
        End If
        
        If i > 1 Then
            ByteArrayToHexStr = ByteArrayToHexStr & " " & HexStr
        Else
            ByteArrayToHexStr = HexStr
        End If
    Next i
End Function


Private Sub GoToMsgTxt()
'Sets up display for input of next message.

    MsgTxt.SetFocus
    MsgTxt.SelStart = 0
    MsgTxt.SelLength = Len(MsgTxt.Text)
End Sub

